/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpPDU;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpVarBind;
import ibm.nways.jdm8260.Jdm8260NicknameTable;
import ibm.nways.jdm8260.Jdm8260SummaryInfo;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MstDecoder;
import ibm.nways.jdm8260.SstDecoder;
import ibm.nways.ras.ErrorLogServerHandle;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Observable;
import java.util.Observer;

public class SummaryTableDumper
implements Observer {
    private InetAddress agentAddr;
    private SnmpSession session;
    private String address;
    private String communityName = "public";
    private int port = 161;
    private int timeout = 2000;
    private int retries = 3;
    private boolean dumpSST = true;
    private boolean dumpEntry = false;
    private MibInfo info = new MibInfo();
    private SstDecoder sstDecoder = new SstDecoder();
    private MstDecoder mstDecoder = new MstDecoder();

    private int getDMMVersionFromSysDescr(String string) {
        char c;
        int n = string.indexOf("(DMM) ");
        if (n == -1) {
            return 0;
        }
        n += 7;
        String string2 = "";
        while ((c = string.charAt(n++)) != '.' && c >= '0' && c <= '9') {
            string2 = String.valueOf(string2) + c;
        }
        return Integer.valueOf(string2);
    }

    public void update(Observable observable, Object object) {
        String string = "update";
        if (object instanceof SnmpVarBind) {
            Object object2;
            Object object3;
            int n;
            SnmpVarBind snmpVarBind = (SnmpVarBind)object;
            OID oID = snmpVarBind.getOID();
            OctetString octetString = (OctetString)snmpVarBind.getVar();
            if (this.dumpEntry) {
                RAS.trace(19, 28, this, string, "Summary Entry : ");
                n = 0;
                object3 = octetString.toString();
                while (true) {
                    String string2 = Integer.toString(n);
                    while (string2.length() < 5) {
                        string2 = "0" + string2;
                    }
                    object2 = null;
                    if (((String)object3).length() > 64) {
                        object2 = ((String)object3).substring(0, 64);
                        object3 = ((String)object3).substring(64);
                    } else {
                        object2 = object3;
                        object3 = null;
                    }
                    RAS.trace(19, 28, this, string, String.valueOf(string2) + ": " + ((String)object2).toUpperCase());
                    if (object3 == null) break;
                    n += 32;
                }
            }
            if (this.dumpSST) {
                n = oID.value.length;
                int n2 = oID.value[n - 2];
                int n3 = oID.value[n - 1];
                object2 = this.sstDecoder;
                ((SstDecoder)object2).setMibInfo(this.info);
                ((SstDecoder)object2).decode(octetString.value, n2, n3);
                return;
            }
            n = oID.value[oID.value.length - 1];
            object3 = this.mstDecoder;
            ((MstDecoder)object3).setMibInfo(this.info);
            ((MstDecoder)object3).decode(octetString.value, n);
        }
    }

    private void dumpTable(String string, Observer observer) {
        OID oID = new OID(string);
        OID oID2 = new OID(string);
        int n = oID2.value.length - 1;
        oID2.value[n] = oID2.value[n] + 1;
        SnmpPDU snmpPDU = this.session.makePDU();
        SnmpPDU snmpPDU2 = null;
        snmpPDU.addVarBind(oID);
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            snmpPDU.requestId = n2;
            snmpPDU.operation = 1;
            try {
                snmpPDU2 = this.session.send(snmpPDU);
            }
            catch (Exception exception) {
                System.out.println("Error sending: " + exception.getMessage());
                return;
            }
            if (snmpPDU2.errorStatus != 0) {
                if (snmpPDU2.errorStatus == 2) {
                    System.out.println("Table " + string + " doesn't exists on agent");
                    bl = false;
                } else {
                    System.out.println("\nReceived errored pdu: " + snmpPDU2.toString());
                    bl = false;
                }
            } else {
                SnmpVarBind snmpVarBind = snmpPDU2.firstVarBind();
                oID = snmpVarBind.getOID();
                if (oID2 != null && oID2.compareTo(oID) < 0) {
                    bl = false;
                } else {
                    if (snmpPDU2.varBindListSize() > 1) {
                        System.out.println("****************** Received more than 1 varbind");
                        System.out.println("Sent:" + snmpPDU.toString());
                        System.out.println("Received:" + snmpPDU2.toString());
                    }
                    if (observer != null) {
                        observer.update(null, snmpVarBind);
                    }
                }
            }
            snmpPDU = snmpPDU2;
        }
    }

    private SnmpVarBind dumpScalar(String string) {
        int n;
        OID oID = new OID(string);
        SnmpPDU snmpPDU = this.session.makePDU();
        SnmpPDU snmpPDU2 = null;
        snmpPDU.addVarBind(oID);
        snmpPDU.requestId = n = 0;
        snmpPDU.operation = 0;
        try {
            snmpPDU2 = this.session.send(snmpPDU);
        }
        catch (Exception exception) {
            System.out.println("Error sending: " + exception.getMessage());
            return null;
        }
        if (snmpPDU2.errorStatus != 0) {
            if (snmpPDU2.errorStatus == 2) {
                System.out.println("Variable " + string + " not found on agent!");
                return null;
            }
            System.out.println("\nReceived errored pdu: " + snmpPDU2.toString());
            return null;
        }
        SnmpVarBind snmpVarBind = snmpPDU2.firstVarBind();
        return snmpVarBind;
    }

    private void init(String[] stringArray) {
        String string = "init";
        this.parseOptions(stringArray);
        try {
            this.agentAddr = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Could not find host " + this.address);
            System.exit(1);
        }
        try {
            SnmpAPI.initialize((int)3333);
        }
        catch (Exception exception) {
            System.out.println("Could not initialize the API");
            return;
        }
        try {
            this.session = SnmpSession.open((String)this.address, (String)this.communityName, (String)"public", (int)this.retries, (int)this.timeout, (int)this.port);
        }
        catch (Exception exception) {
            System.out.println("Failed to open session to " + this.address + " -- error = " + exception.toString());
            exception.printStackTrace();
            return;
        }
        SnmpVarBind snmpVarBind = this.dumpScalar("1.3.6.1.2.1.1.2.0");
        if (snmpVarBind == null) {
            return;
        }
        Serializable serializable = snmpVarBind.getVar();
        RAS.trace(19, 28, this, string, "Agent sysObjectID -> " + serializable);
        String string2 = serializable.toString();
        String string3 = "1.3.6.1.4.1.49.2.3.1.4.12.1.1.3";
        String string4 = "1.3.6.1.4.1.49.2.3.1.4.5.1.2";
        if (string2.equals("1.3.6.1.4.1.49.2.3.12")) {
            snmpVarBind = this.dumpScalar("1.3.6.1.2.1.1.1.0");
            if (snmpVarBind == null) {
                return;
            }
            serializable = snmpVarBind.getVar();
            RAS.trace(19, 28, this, string, "Agent sysDescr    -> " + ((OctetString)serializable).toDisplayString());
            int n = this.getDMMVersionFromSysDescr(((OctetString)serializable).toDisplayString());
            if (n < 3) {
                this.dumpSST = false;
            }
        } else {
            int n = Jdm8260SummaryInfo.modelFromSysOid(string2);
            if (n == -1) {
                RAS.trace(19, 28, this, string, "Unknown Hub model -> " + string2);
                return;
            }
            if (n == 0) {
                this.dumpSST = false;
            } else if (n == 2 || n == 1 && string2.equals("1.3.6.1.4.1.2.6.33.2.1")) {
                string3 = "1.3.6.1.4.1.2.6.33.5.4.12.1.1.3";
            }
        }
        this.info.setModelAndNicknames(null, new Jdm8260NicknameTable());
        if (this.dumpSST) {
            this.dumpTable(string3, this);
            return;
        }
        this.dumpTable(string4, this);
    }

    public int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public void parseOptions(String[] stringArray) {
        int n = 0;
        this.address = stringArray[n++];
        while (n < stringArray.length) {
            if (stringArray[n].equals("-p")) {
                this.port = this.parseInt(stringArray[++n], 161);
                ++n;
                continue;
            }
            if (stringArray[n].equals("-c")) {
                this.communityName = stringArray[++n];
                ++n;
                continue;
            }
            if (stringArray[n].equals("-r")) {
                this.retries = this.parseInt(stringArray[++n], 3);
                ++n;
                continue;
            }
            if (stringArray[n].equals("-t")) {
                this.timeout = this.parseInt(stringArray[++n], 2000);
                ++n;
                continue;
            }
            if (stringArray[n].equals("-d")) {
                String string = stringArray[++n];
                ++n;
                if (string.equals("yes")) {
                    this.dumpEntry = true;
                    continue;
                }
                if (string.equals("no")) continue;
                System.out.println("Ignored value for option -d: " + string);
                System.out.println("Valid values are 'yes' or 'no'");
                continue;
            }
            System.out.println("Unrecognied ignored option " + stringArray[n++]);
            ++n;
        }
    }

    public static void usage() {
        System.out.println("Usage:\n");
        System.out.println("java ibm.nways.jdm8260.SummaryTableDumper <IP address>");
        System.out.println("   [-p <port number>] [-c <community name>] [-r <retries>] [-t <timeout>]");
        System.out.println("   [-d yes|no]\n");
        System.out.println("   <IP address>        - the agent's IP address");
        System.out.println("   -p <port number>    - the agent's SNMP port number (default 161)");
        System.out.println("   -c <community name> - the read community name (default public)");
        System.out.println("   -r <retries>        - the number of retries (default 3)");
        System.out.println("   -t <timeout>        - the timeout for the requests (default 2000)");
        System.out.println("   -d yes|no           - dump the table entry (default no)");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length % 2 != 1) {
            SummaryTableDumper.usage();
            System.exit(1);
        }
        SummaryTableDumper summaryTableDumper = new SummaryTableDumper();
        summaryTableDumper.init(stringArray);
        System.exit(0);
    }

    class TraceServer
    implements ErrorLogServerHandle {
        public void trace(String string) {
            System.out.println(string);
        }

        public void log(String string) {
            this.trace(string);
        }

        public void close() {
        }

        public void flush() {
        }

        TraceServer() {
            SummaryTableDumper.this = SummaryTableDumper.this;
        }
    }
}

